IF EXISTS (SELECT *
           FROM   sys.objects
           WHERE  object_id = Object_id(N'[dbo].[P_BUSCA_QT_SOL_PED_CP_ATIVA_CP]')
                  AND type IN ( N'P', N'PC' ))
  DROP PROCEDURE [dbo].[P_BUSCA_QT_SOL_PED_CP_ATIVA_CP]

GO
 
 
CREATE PROCEDURE [dbo].[P_BUSCA_QT_SOL_PED_CP_ATIVA_CP]  (@CD_EMP INT = 1, @CD_GRP_PED varchar(max)='') 
AS
BEGIN

SET NOCOUNT ON;
SET DEADLOCK_PRIORITY 10;

CREATE TABLE #BUSCA_QT_SOL_PED_CP
(CD_EMP              INT,
 CD_PED_SOL          INT,
 CD_FILIAL           INT,
 CD_FORN             INT,
 CD_INT              INT,
 CD_FIL_FORN         VARCHAR(50),
 CD_PROD             INT,
 CD_PROD_FORN        VARCHAR(50),
 DS_PROD             VARCHAR(300),
 DS_UN               VARCHAR(25),
 QT_IT_SOL           MONEY,
 QT_IT_AT            MONEY,
 QT_SLD              MONEY,
 CONV_UNIDADE        INT,
 QT_IT_UN            MONEY,
 QT_IT_AT_UN         MONEY,
 QT_SLD_UN           MONEY,
 VLR_PROD            MONEY,
 VLR_TOT_PROD        MONEY,
 CD_FABRIC           INT,
 NM_FABRIC           VARCHAR(400),
 PERC_DESC           MONEY,
 CTR_PMC             INT,
 CD_BARRA            VARCHAR(50),
 FLAG_GERAR_CROSS    INT,
 TP_REQ              INT,
 CD_ROTEIRO          INT,
 CD_ORD_ROTEIRO      INT,
 CD_PED_CP_PARAM     INT,
 CD_ORD_CP_PARAM     INT,
 CD_ORD_MCP          INT,
 CD_ORD_DEFAULT      INT,
 CD_CTR_ATIVA        INT,
 CONDICAO            VARCHAR(50),
 ST_PED_VAZIO        INT,
 ST_PED_VAZIO_MOTIVO VARCHAR(100),
 QT_EMB              MONEY
);

CREATE TABLE #RS_ROTEIRO_CP(CD_ROTEIRO INT);

CREATE TABLE #RS_PROD_PEND
(CD_EMP       INT,
 CD_PED_SOL   INT,
 CD_FILIAL    INT,
 CD_PROD      INT,
 QT_IT_SOL    MONEY,
 QT_IT_AT     MONEY,
 QT_SLD       MONEY,
 CONV_UNIDADE INT,
 QT_IT_UN     MONEY,
 QT_IT_AT_UN  MONEY,
 QT_SLD_UN    MONEY,
 VLR_PROD     MONEY,
 CD_CTR_ATIVA INT,
 CD_ROTEIRO   INT
);

CREATE TABLE #RS_PROD_SLD
(CD_EMP      INT,
 CD_FIL_ENTR INT,
 CD_PED_SOL  INT,
 CD_PROD     INT,
 SLD_PROD    MONEY,
 SLD_PROD_UN MONEY,
 PRIMARY KEY(CD_EMP, CD_PED_SOL, CD_PROD)
);

CREATE TABLE #RS_PROD_CP_PARAM_CAB
(CD_CTR_HIST     INT,
 CD_ROTEIRO      INT,
 CD_ORD_ROTEIRO  INT,
 CD_PED_CP_PARAM INT,
 CD_ORD_CP_PARAM INT,
 CD_ORD_MCP      INT,
 CD_ORD_DEFAULT  INT,
 CD_EMP          INT,
 CD_PED_SOL      INT,
 CD_FILIAL       INT,
 CD_FORN         INT,
 CD_INT          INT,
 CD_CTR_ATIVA    INT,
 CONDICAO        VARCHAR(50),
 FLAG_PARAM_MCP  INT
);

CREATE TABLE #RS_PROD_CP_PARAM
(CD_CTR_HIST         INT,
 CD_ROTEIRO          INT,
 CD_ORD_ROTEIRO      INT,
 CD_PED_CP_PARAM     INT,
 CD_ORD_CP_PARAM     INT,
 CD_ORD_MCP          INT,
 CD_ORD_DEFAULT      INT,
 CD_EMP              INT,
 CD_PED_SOL          INT,
 CD_FILIAL           INT,
 CD_PROD             INT,
 CD_FORN             INT,
 CD_INT              INT,
 CD_CTR_ATIVA        INT,
 CONDICAO            VARCHAR(50),
 FLAG_PARAM_MCP      INT,
 ST_PED_VAZIO        INT,
 ST_PED_VAZIO_MOTIVO VARCHAR(100)
);

CREATE TABLE #RS_PROD_CP_PARAM_HIST
(CD_EMP          INT,
 CD_CTR_ATIVA    INT,
 CD_ROTEIRO      INT,
 CD_ORD_ROTEIRO  INT,
 CD_PED_CP_PARAM INT,
 CD_ORD_CP_PARAM INT,
 CD_PED_SOL      INT,
 CD_FORN         INT,
 CD_INT          INT
);
CREATE TABLE #RS_EST_PED_ELTR
(CD_EMP       INT,
 CD_PED_SOL   INT,
 CD_FILIAL    INT,
 CD_CTR_ATIVA INT,
 CD_ROTEIRO   INT
);
         
CREATE TABLE #RS_PROD_MCP
(CD_EMP          INT,
 CD_ORD_MCP      INT,
 CD_PROD         INT,
 CD_FORN         INT,
 CD_PED_CP_PARAM INT
);
 --------------------------------------------------------------------------------------------------    
 --ALTERANDO O STATUS DE ENVIO DO PEDIDO ELTRONICO      
 --------------------------------------------------------------------------------------------------      
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - ALTERANDO STATUS DOS PEDIDOS ELETRONICOS JA RETORNADOS PARA 2 - AGUARDANDO REENVIO'		 
 --------------------------------------------------------------------------------------------------      
  IF EXISTS(SELECT eltr.cd_emp
				FROM
					EST_PED_ELTR ELTR
					INNER JOIN EST_PED_ELTR_ATIVA_CP_EST_PED_ELTR ELTR_ATV ON ELTR.CD_EMP = ELTR_ATV.CD_EMP
																			  AND ELTR.CD_PED_SOL = ELTR_ATV.CD_PED_SOL
					INNER JOIN EST_PED_ELTR_ATIVA_CP ATV ON ELTR_ATV.CD_CTR = ATV.CD_CTR
				WHERE  ELTR.STS_PED = 1
					   AND ELTR.CD_EMP = 1
					   AND DATEDIFF(HOUR, ELTR.HORA_DEMANDA, GETDATE()) > 24
					   AND NOT EXISTS
				(
					SELECT
						   H.CD_EMP
					FROM
						EST_PED_ELTR_ATIVA_CP_HIST_PARAM H
					WHERE  ELTR.CD_EMP = H.CD_EMP
						   AND ELTR.CD_PED_SOL = H.CD_PED_SOL
						   AND ATV.CD_CTR = H.CD_CTR
						   AND H.ST_RET = 0
				) 
           )
begin
	UPDATE ELTR SET STS_PED = 2
	FROM 
		EST_PED_ELTR ELTR  
		INNER JOIN EST_PED_ELTR_ATIVA_CP_EST_PED_ELTR ELTR_ATV ON 
		ELTR.CD_EMP 		= ELTR_ATV.CD_EMP 
		AND ELTR.CD_PED_SOL = ELTR_ATV.CD_PED_SOL 
		INNER JOIN EST_PED_ELTR_ATIVA_CP ATV ON 
		ELTR_ATV.CD_CTR = ATV.CD_CTR 
	WHERE
		ELTR.STS_PED =1
		AND ELTR.CD_EMP=1
		AND DATEDIFF(HOUR,ELTR.HORA_DEMANDA,GETDATE()) > 24 
		AND NOT EXISTS (SELECT H.CD_EMP
						FROM EST_PED_ELTR_ATIVA_CP_HIST_PARAM H
						WHERE ELTR.CD_EMP 		= H.CD_EMP
							AND ELTR.CD_PED_SOL 	= H.CD_PED_SOL
							AND ATV.CD_CTR			= H.CD_CTR 
							AND H.ST_RET = 0);
end 
 --------------------------------------------------------------------------------------------------    
 --FINALIZANDO ATIVACOES DE COMPRA DO DIA ANTERIOR QUE NAO POSSUI RETORNO PENDENTE      
 --------------------------------------------------------------------------------------------------           
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - FINALIZANDO ATIVACOES DE COMPRA DO DIA ANTERIOR QUE NAO POSSUI RETORNO PENDENTE'		 
 --------------------------------------------------------------------------------------------------           

UPDATE ATV
  SET
	  STS_ATIVA = 1
FROM   EST_PED_ELTR_ATIVA_CP ATV
WHERE
	  datediff(hour,convert(datetime, convert(varchar, dt_ativa,112) + ' ' + 	convert(varchar, HR_ATIVA, 108)) 	,getdate()) > 24 
	  AND ATV.CD_EMP = @CD_EMP
	  AND ATV.STS_ATIVA = 0
	  AND EXISTS(SELECT H.CD_EMP FROM
					EST_PED_ELTR_ATIVA_CP_HIST H 
					WHERE  H.CD_EMP = ATV.CD_EMP
						AND H.CD_CTR = ATV.CD_CTR)
	  AND NOT EXISTS(SELECT H.CD_EMP FROM
							EST_PED_ELTR_ATIVA_CP_HIST_PARAM H
						WHERE  H.CD_EMP = ATV.CD_EMP
							   AND H.CD_CTR = ATV.CD_CTR
							   AND H.ST_RET = 0);

 --------------------------------------------------------------------------------------------------    
 --CANCELANDO O SALDO DE PEDIDOS QUE JA FORAM EXECUTADADOS PELO PW      
 --------------------------------------------------------------------------------------------------      
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - CANCELANDO O SALDO DE PEDIDOS QUE JA FORAM EXECUTADADOS PELO PW' 
 --------------------------------------------------------------------------------------------------      
UPDATE ELTR SET FLAG_FECHAR = 1, STS_PED = 3
FROM 
	EST_PED_ELTR ELTR
	INNER JOIN EST_PED_ELTR_ATIVA_CP_EST_PED_ELTR ATV_E ON
	ELTR.CD_EMP = ATV_E.CD_EMP
	AND ELTR.CD_PED_SOL = ATV_E.CD_PED_SOL
WHERE
	ELTR.FLAG_FECHAR = 0
	AND ELTR.CD_EMP=@CD_EMP
	AND DATEDIFF(HOUR,ELTR.HORA_DEMANDA,GETDATE()) > 24 
	AND NOT EXISTS (SELECT ATV.CD_EMP
					FROM EST_PED_ELTR_ATIVA_CP ATV
					WHERE 
						ATV.CD_EMP = ATV_E.CD_EMP
						AND ATV.CD_CTR = ATV_E.CD_CTR
						AND ATV.STS_ATIVA = 0);
    
 --------------------------------------------------------------------------------------------------
 --Cancelamento do saldo de faltas
 --------------------------------------------------------------------------------------------------
DECLARE  @QT_HRS_AGUARDAR INT;
  
SET @QT_HRS_AGUARDAR = ISNULL((SELECT VALOR 
								FROM PRC_EMP_CONFIG WHERE CD_EMP=@CD_EMP AND CD_CHAVE ='PW_TEMPO_CANC_PED_NAO_RETORNADO'),0);

IF @QT_HRS_AGUARDAR > 0
BEGIN
	CREATE TABLE #TmpDemandaFechar ( CD_EMP INT, CD_PED_SOL INT , CD_CTR INT);

	INSERT INTO #TmpDemandaFechar 
	SELECT 
		ELTR.CD_EMP,
		ELTR.CD_PED_SOL,
		ATV_E.CD_CTR
	FROM 
		EST_PED_ELTR ELTR
		INNER JOIN EST_PED_ELTR_ATIVA_CP_EST_PED_ELTR ATV_E ON
		ELTR.CD_EMP		= ATV_E.CD_EMP AND 
		ELTR.CD_PED_SOL = ATV_E.CD_PED_SOL
		JOIN EST_PED_ELTR_ATIVA_CP  C ON 
		ATV_E.CD_EMP = C.CD_EMP AND 
		ATV_E.CD_CTR = C.CD_CTR
	WHERE
		ELTR.FLAG_FECHAR = 0
		AND ELTR.CD_EMP=1
		AND datediff(hour,convert(datetime, convert(varchar, c.dt_ativa,112) + ' ' + 	convert(varchar, c.HR_ATIVA, 108)) 	,getdate()) > @QT_HRS_AGUARDAR
		AND ELTR.STS_PED=1;
	
	UPDATE E
	SET
		FLAG_FECHAR =1, 
		STS_PED =3, 
		DT_ULT_ATU= GETDATE()
	FROM 
		EST_PED_ELTR E
		JOIN #TmpDemandaFechar F ON 
		E.CD_EMP	 = F.CD_EMP AND 
		E.CD_PED_SOL = F.CD_PED_SOL;

	UPDATE A
	SET FLAG_FECHAR=1
	FROM 
		EST_PED_ELTR_ATIVA_CP_EST_PED_ELTR A
		JOIN #TmpDemandaFechar F ON 
		A.CD_EMP	 = F.CD_EMP AND 
		A.CD_CTR	 = F.CD_CTR AND 
		A.CD_PED_SOL = F.CD_PED_SOL;

END
 --------------------------------------------------------------------------------------------------    
 --VERIFICANDO SE O ROTEIRO PODE SER EXECUTADO NESTE DIA DA SEMANA
 -------------------------------------------------------------------------------------------------- 
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - VERIFICANDO SE O ROTEIRO PODE SER EXECUTADO NESTE DIA DA SEMANA'
 -------------------------------------------------------------------------------------------------- 
 INSERT INTO #RS_ROTEIRO_CP
   SELECT
    ROT.CD_ROTEIRO
   FROM EST_PED_CP_ROTEIRO_CP ROT
    INNER JOIN EST_PED_CP_ROTEIRO_CP_AGD_SEMANA ROT_AGD ON
     ROT.CD_ROTEIRO = ROT_AGD.CD_ROTEIRO
   WHERE
    ROT.STS_ROREIRO = 0
    AND ROT_AGD.CD_DIA = Datepart(DW, Getdate())
     
 --------------------------------------------------------------------------------------------------    
 --CAPTURANDO OS PEDIDOS ELETRONICOS ATIVADOS NO PW QUE NAO POSSUI RETORNO PENDENTE
 --------------------------------------------------------------------------------------------------   
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - CAPTURANDO OS PEDIDOS ELETRONICOS ATIVADOS NO PW QUE NAO POSSUI RETORNO PENDENTE'
 --------------------------------------------------------------------------------------------------   
 if len(@CD_GRP_PED ) > 0  
begin  
    
	create table #TmpCtr (CD_EMP int, CD_GRP_PED int)
	
	insert into #TmpCtr 
	select @CD_EMP ,id 
	from 
		[UFD_PRM_IN_STRING]  (@CD_GRP_PED)
		 

	INSERT INTO #RS_EST_PED_ELTR
    SELECT EST_PED_ELTR.CD_EMP,
            EST_PED_ELTR.CD_PED_SOL,
            EST_PED_ELTR.CD_FIL_ENTR,
            ATIVA_CP.CD_CTR AS CD_CTR_ATIVA,
            ATIVA_ROT.CD_ROTEIRO
    FROM 
		EST_PED_ELTR
        INNER JOIN EST_PED_ELTR_ATIVA_CP_EST_PED_ELTR ATIVA_CP_IT ON EST_PED_ELTR.CD_EMP = ATIVA_CP_IT.CD_EMP
                                                                        AND EST_PED_ELTR.CD_PED_SOL = ATIVA_CP_IT.CD_PED_SOL
        
		
		JOIN EST_PED_ELTR_GRP_PED_EST_PED_ELTR h ON EST_PED_ELTR.CD_EMP = h.CD_EMP
                                                    AND EST_PED_ELTR.CD_PED_SOL = h.CD_PED_SOL
		join #TmpCtr T on 
			t.CD_EMP	 = h.CD_EMP 
		AND h.CD_GRP_PED = h.CD_GRP_PED 

        INNER JOIN EST_PED_ELTR_ATIVA_CP ATIVA_CP ON ATIVA_CP_IT.CD_EMP = ATIVA_CP.CD_EMP
                                                        AND ATIVA_CP_IT.CD_CTR = ATIVA_CP.CD_CTR
        INNER JOIN EST_PED_ELTR_ATIVA_CP_EST_PED_CP_ROTEIRO_CP ATIVA_ROT ON ATIVA_CP.CD_EMP = ATIVA_ROT.CD_EMP
                                                                            AND ATIVA_CP.CD_CTR = ATIVA_ROT.CD_CTR
        INNER JOIN #RS_ROTEIRO_CP RS_ROTEIRO_CP ON RS_ROTEIRO_CP.CD_ROTEIRO = ATIVA_ROT.CD_ROTEIRO
    WHERE EST_PED_ELTR.CD_EMP = @CD_EMP
            AND EST_PED_ELTR.STS_PED <> 3
            AND EST_PED_ELTR.FLAG_FECHAR = 0
            
            AND ATIVA_CP.STS_ATIVA = 0
            AND NOT EXISTS (
									SELECT ROT_HIST.CD_EMP
									FROM EST_PED_ELTR_ATIVA_CP_HIST_PARAM ROT_HIST
									WHERE ROT_HIST.CD_EMP = ATIVA_ROT.CD_EMP
										  AND ROT_HIST.CD_ROTEIRO = ATIVA_ROT.CD_ROTEIRO
										  AND ROT_HIST.CD_PED_SOL = EST_PED_ELTR.CD_PED_SOL
										  AND ROT_HIST.ST_RET = 0
								);     
  
  
end  
else  
begin  
    INSERT INTO #RS_EST_PED_ELTR  
    SELECT  
     EST_PED_ELTR.CD_EMP,  
     EST_PED_ELTR.CD_PED_SOL,  
     EST_PED_ELTR.CD_FIL_ENTR,  
     ATIVA_CP.CD_CTR  AS CD_CTR_ATIVA,  
     ATIVA_ROT.CD_ROTEIRO  
          
    FROM   
     EST_PED_ELTR  
     INNER JOIN EST_PED_ELTR_ATIVA_CP_EST_PED_ELTR ATIVA_CP_IT ON  
     EST_PED_ELTR.CD_EMP   = ATIVA_CP_IT.CD_EMP AND  
     EST_PED_ELTR.CD_PED_SOL  = ATIVA_CP_IT.CD_PED_SOL  
     INNER JOIN EST_PED_ELTR_ATIVA_CP ATIVA_CP ON  
     ATIVA_CP_IT.CD_EMP   = ATIVA_CP.CD_EMP AND  
     ATIVA_CP_IT.CD_CTR   = ATIVA_CP.CD_CTR  
     INNER JOIN EST_PED_ELTR_ATIVA_CP_EST_PED_CP_ROTEIRO_CP ATIVA_ROT ON  
     ATIVA_CP.CD_EMP    = ATIVA_ROT.CD_EMP AND  
     ATIVA_CP.CD_CTR    = ATIVA_ROT.CD_CTR  
     INNER JOIN #RS_ROTEIRO_CP RS_ROTEIRO_CP ON  
     RS_ROTEIRO_CP.CD_ROTEIRO = ATIVA_ROT.CD_ROTEIRO  
    WHERE  
     EST_PED_ELTR.CD_EMP    = @CD_EMP  
     AND EST_PED_ELTR.STS_PED  <> 3  
     AND EST_PED_ELTR.FLAG_FECHAR = 0  
     AND ATIVA_CP.STS_ATIVA      = 0   
     AND NOT EXISTS (SELECT ROT_HIST.CD_EMP  
          FROM EST_PED_ELTR_ATIVA_CP_HIST_PARAM ROT_HIST  
          WHERE ROT_HIST.CD_EMP   = ATIVA_ROT.CD_EMP  
          AND ROT_HIST.CD_ROTEIRO = ATIVA_ROT.CD_ROTEIRO  
          AND ROT_HIST.CD_PED_SOL = EST_PED_ELTR.CD_PED_SOL  
          AND ROT_HIST.ST_RET  = 0)     
 end 
    
 --------------------------------------------------------------------------------------------------    
 --DEFININDO A ORDEM DE EXECUCAO DOS ROTEIROS E PARAMETROS DO PW OU O PLANO DE EXECUCAO DA MELHOR CONDICAO DE COMPRA
 --------------------------------------------------------------------------------------------------                
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - DEFININDO A ORDEM DE EXECUCAO DOS ROTEIROS E PARAMETROS DO PW OU O PLANO DE EXECUCAO DA MELHOR CONDICAO DE COMPRA'
 --------------------------------------------------------------------------------------------------                
 INSERT INTO #RS_PROD_CP_PARAM_CAB
    (CD_CTR_HIST  ,
      CD_ROTEIRO  ,
      CD_ORD_ROTEIRO ,
      CD_PED_CP_PARAM ,
      CD_ORD_CP_PARAM ,
      CD_ORD_MCP  ,
      CD_ORD_DEFAULT ,
      CD_EMP   ,
      CD_PED_SOL  ,
      CD_FILIAL   ,
      CD_FORN   ,
      CD_INT   ,
      CD_CTR_ATIVA  ,
      CONDICAO,
	  FLAG_PARAM_MCP)
  SELECT
   Row_number() OVER (ORDER BY ROT_CP_PARAM.CD_ROTEIRO) AS CD_CTR,
   ROT_CP_PARAM.CD_ROTEIRO,
   ROT_CP_PARAM.CD_ORD_ROTEIRO,
   CP_PARAM_FORN.CD_PED_CP_PARAM,
   CP_PARAM_FORN.CD_ORD_CP_PARAM,
   0 AS CD_ORD_MCP,
   0 AS CD_ORD_DEFAULT,
   RS_EST_PED_ELTR.CD_EMP,
   RS_EST_PED_ELTR.CD_PED_SOL,
   RS_EST_PED_ELTR.CD_FILIAL,
   CP_PARAM_FORN.CD_FORN,
   CP_PARAM_FORN.CD_INT,
   RS_EST_PED_ELTR.CD_CTR_ATIVA,
   Isnull(CP_PARAM_FORN.CONDICAO,'') AS CONDICAO,   
   ISNULL(CP_PARAM.FLAG_PARAM_MCP,0) AS FLAG_PARAM_MCP
    
  FROM 
	#RS_EST_PED_ELTR RS_EST_PED_ELTR
	INNER JOIN EST_PED_CP_ROTEIRO_CP_EST_PED_CP_PARAM ROT_CP_PARAM ON
	RS_EST_PED_ELTR.CD_ROTEIRO   = ROT_CP_PARAM.CD_ROTEIRO
	INNER JOIN EST_PED_CP_PARAM CP_PARAM ON
	ROT_CP_PARAM.CD_EMP     = CP_PARAM.CD_EMP
	AND ROT_CP_PARAM.CD_PED_CP_PARAM = CP_PARAM.CD_PED_CP_PARAM
	INNER JOIN EST_PED_CP_PARAM_PG_FORN_INTEGRACAO CP_PARAM_FORN ON
	CP_PARAM.CD_EMP      = CP_PARAM_FORN.CD_EMP
	AND CP_PARAM.CD_PED_CP_PARAM  = CP_PARAM_FORN.CD_PED_CP_PARAM
    
  WHERE
	CP_PARAM.CD_EMP    = @CD_EMP
	AND NOT EXISTS (SELECT ROT_HIST.CD_EMP
				  FROM EST_PED_ELTR_ATIVA_CP_HIST_PARAM ROT_HIST
				  WHERE ROT_HIST.CD_EMP    = RS_EST_PED_ELTR.CD_EMP
					 AND ROT_HIST.CD_CTR   = RS_EST_PED_ELTR.CD_CTR_ATIVA
					 AND ROT_HIST.CD_ROTEIRO  = ROT_CP_PARAM.CD_ROTEIRO
					 AND ROT_HIST.CD_ORD_ROTEIRO = ROT_CP_PARAM.CD_ORD_ROTEIRO
					 AND ROT_HIST.CD_PED_CP_PARAM  = CP_PARAM_FORN.CD_PED_CP_PARAM
					 AND ROT_HIST.CD_ORD_CP_PARAM = CP_PARAM_FORN.CD_ORD_CP_PARAM
					 AND ROT_HIST.CD_PED_SOL  = RS_EST_PED_ELTR.CD_PED_SOL
					 AND ISNULL(ROT_HIST.CD_ORD_MCP,0)  =   (CASE WHEN CP_PARAM.FLAG_PARAM_MCP = 1 THEN 
																(SELECT COUNT(1) 
																 FROM EST_PED_CP_PARAM_PG_FORN_INTEGRACAO I_CP_PARAM_FORN 
																 WHERE ROT_HIST.CD_EMP      		= I_CP_PARAM_FORN.CD_EMP
																	   AND ROT_HIST.CD_PED_CP_PARAM = I_CP_PARAM_FORN.CD_PED_CP_PARAM)
															 ELSE
																 0
															 END))
     
 
 --------------------------------------------------------------------------------------------------    
 --DEFININDO A PROXIMA ORDEM DA MELHOR CONDICAO DE COMPRA       
 -------------------------------------------------------------------------------------------------- 	
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - DEFININDO A PROXIMA ORDEM DA MELHOR CONDICAO DE COMPRA'
 -------------------------------------------------------------------------------------------------- 	 
	IF EXISTS(SELECT TOP 1 CD_EMP FROM #RS_PROD_CP_PARAM_CAB WHERE FLAG_PARAM_MCP = 1)
		BEGIN 
			UPDATE CAB SET 
				CD_ORD_MCP =  ISNULL((SELECT MAX(ROT_HIST.CD_ORD_MCP)
									  FROM EST_PED_ELTR_ATIVA_CP_HIST_PARAM ROT_HIST
									  WHERE ROT_HIST.CD_EMP    = CAB.CD_EMP
										 AND ROT_HIST.CD_CTR   = CAB.CD_CTR_ATIVA
										 AND ROT_HIST.CD_ROTEIRO  = CAB.CD_ROTEIRO
										 AND ROT_HIST.CD_ORD_ROTEIRO = CAB.CD_ORD_ROTEIRO
										 AND ROT_HIST.CD_PED_CP_PARAM  = CAB.CD_PED_CP_PARAM
										 AND ROT_HIST.CD_ORD_CP_PARAM = CAB.CD_ORD_CP_PARAM
										 AND ROT_HIST.CD_PED_SOL  = CAB.CD_PED_SOL),0) + 1 
			FROM #RS_PROD_CP_PARAM_CAB CAB
			WHERE CAB.FLAG_PARAM_MCP = 1
		END 
		
 --------------------------------------------------------------------------------------------------    
 --ALIMENTANDO A TABELA DE PEDIDOS ELETRONICOS PENDENTES ATIVADOS QUE NAO POSSUI RETORNO PENDENTE      
 --------------------------------------------------------------------------------------------------         
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - ALIMENTANDO A TABELA DE PEDIDOS ELETRONICOS PENDENTES ATIVADOS QUE NAO POSSUI RETORNO PENDENTE'
 --------------------------------------------------------------------------------------------------         
 INSERT INTO #RS_PROD_PEND
   SELECT
    EST_PED_ELTR.CD_EMP,
    EST_PED_ELTR.CD_PED_SOL,
    EST_PED_ELTR.CD_FIL_ENTR,
    EST_PED_ELTR_IT.CD_PROD,
    EST_PED_ELTR_IT.QT_IT AS QT_IT_SOL,
    0      AS QT_IT_AT,
    EST_PED_ELTR_IT.QT_IT AS QT_SLD,
	Isnull(EST_PED_ELTR_IT.UNIDADE,0) AS CONV_UNIDADE,
	(CASE WHEN Isnull(EST_PED_ELTR_IT.UNIDADE,0) = 1 THEN
		Isnull(EST_PED_ELTR_IT.QT_IT_UN,0)
	 ELSE
		EST_PED_ELTR_IT.QT_IT * (CONVERT(MONEY,REPLACE(EST_PROD.APRES_EMB_CP,',','.')) *  CONVERT(MONEY,REPLACE(EST_PROD.APRES_QT_CP,',','.')) )
	 END) AS QT_IT_UN,
	0	   AS QT_AT_UN,
	(CASE WHEN Isnull(EST_PED_ELTR_IT.UNIDADE,0) = 1 THEN
		Isnull(EST_PED_ELTR_IT.QT_IT_UN,0)
	 ELSE
		EST_PED_ELTR_IT.QT_IT * (CONVERT(MONEY,REPLACE(EST_PROD.APRES_EMB_CP,',','.')) *  CONVERT(MONEY,REPLACE(EST_PROD.APRES_QT_CP,',','.')) )
	 END) AS QT_SLD_UN,
    EST_PED_ELTR_IT.VLR_PROD,
    RS_EST_PED_ELTR.CD_CTR_ATIVA,
    RS_EST_PED_ELTR.CD_ROTEIRO
   FROM
    EST_PED_ELTR
    INNER JOIN EST_PED_ELTR_IT ON
     EST_PED_ELTR.CD_EMP   = EST_PED_ELTR_IT.CD_EMP AND
     EST_PED_ELTR.CD_PED_SOL  = EST_PED_ELTR_IT.CD_PED_SOL
    INNER JOIN #RS_EST_PED_ELTR RS_EST_PED_ELTR ON
     EST_PED_ELTR.CD_EMP   = RS_EST_PED_ELTR.CD_EMP AND
     EST_PED_ELTR.CD_PED_SOL  = RS_EST_PED_ELTR.CD_PED_SOL
	INNER JOIN EST_PROD ON
	 EST_PED_ELTR_IT.CD_EMP = EST_PROD.CD_EMP AND
	 EST_PED_ELTR_IT.CD_PROD = EST_PROD.CD_PROD
	WHERE 
    EST_PED_ELTR_IT.CD_EMP =@CD_EMP
    
 --------------------------------------------------------------------------------------------        
 --VERIFICANDO OS PRODUTOS QUE JA POSSUI PEDIDO DE COMPRA.        
 -------------------------------------------------------------------------------------------- 
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - VERIFICANDO OS PRODUTOS QUE JA POSSUI PEDIDO DE COMPRA.'
 -------------------------------------------------------------------------------------------- 
 INSERT INTO #RS_PROD_SLD
   SELECT DISTINCT
   
    EST_PED_ELTR_FORN_PED_CP.CD_EMP,
    EST_PED_ELTR_FORN_PED_CP.CD_FIL_ENTR,
    EST_PED_ELTR_FORN_PED_CP.CD_PED_SOL,
    EST_PED_CP_IT.CD_PROD,
    Isnull(Sum(EST_PED_CP_IT.QT_IT),0) AS SLD_PROD,
	Isnull(Sum(EST_PED_CP_IT.QT_IT * EST_PED_CP_IT.QT_EMB),0) AS SLD_PROD_UN
	
   FROM EST_PED_ELTR_FORN_PED_CP 
   INNER JOIN EST_PED_CP_IT ON 
		EST_PED_ELTR_FORN_PED_CP.CD_EMP = EST_PED_CP_IT.CD_EMP AND 
		EST_PED_ELTR_FORN_PED_CP.CD_FIL_ENTR = EST_PED_CP_IT.CD_FILIAL AND 
		EST_PED_ELTR_FORN_PED_CP.CD_PED = EST_PED_CP_IT.CD_PED  
   WHERE
    EST_PED_ELTR_FORN_PED_CP.CD_EMP = @CD_EMP
    AND EXISTS (SELECT RS_PROD_PEND.CD_EMP
       FROM #RS_PROD_PEND RS_PROD_PEND
       WHERE RS_PROD_PEND.CD_EMP   = EST_PED_ELTR_FORN_PED_CP.CD_EMP
          AND RS_PROD_PEND.CD_PED_SOL = EST_PED_ELTR_FORN_PED_CP.CD_PED_SOL)
   GROUP BY
    EST_PED_ELTR_FORN_PED_CP.CD_EMP,
    EST_PED_ELTR_FORN_PED_CP.CD_FIL_ENTR,
    EST_PED_ELTR_FORN_PED_CP.CD_PED_SOL,
    EST_PED_CP_IT.CD_PROD
         
         
 --------------------------------------------------------------------------------------------        
 --ABATENDO A QUANTIDADE JA ATRIBUIDA AO PEDIDO DE COMPRA.        
 --------------------------------------------------------------------------------------------    
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - ABATENDO A QUANTIDADE JA ATRIBUIDA AO PEDIDO DE COMPRA.'
 --------------------------------------------------------------------------------------------    
 UPDATE RS_PROD_PEND SET
  QT_IT_AT = RS_PROD_SLD.SLD_PROD,
  QT_IT_AT_UN = RS_PROD_SLD.SLD_PROD_UN,
  QT_SLD  = (RS_PROD_PEND.QT_IT_SOL - RS_PROD_SLD.SLD_PROD) ,
  QT_SLD_UN = (RS_PROD_PEND.QT_IT_UN - RS_PROD_SLD.SLD_PROD_UN)
 FROM
  #RS_PROD_SLD RS_PROD_SLD INNER JOIN  #RS_PROD_PEND RS_PROD_PEND ON
   RS_PROD_SLD.CD_EMP  = RS_PROD_PEND.CD_EMP  AND
   RS_PROD_SLD.CD_PED_SOL = RS_PROD_PEND.CD_PED_SOL AND
   RS_PROD_SLD.CD_PROD  = RS_PROD_PEND.CD_PROD
    
    
 --------------------------------------------------------------------------------------------        
 --EXCLUINDO PRODUTOS COMPLETAMENTE ATENDIDO        
 --------------------------------------------------------------------------------------------  
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - EXCLUINDO PRODUTOS COMPLETAMENTE ATENDIDO'
 --------------------------------------------------------------------------------------------  
 DELETE FROM #RS_PROD_PEND
 WHERE QT_SLD_UN <= 0
     
    
 --##########################################################################################    
 --INICIANDO TRATAMENTO DE CONDICOES COMERCIAIS DO PW    
 --##########################################################################################    
           
CREATE NONCLUSTERED INDEX  IX_#RS_PROD_PEND_VLR_PROD	ON [dbo].[#RS_PROD_PEND] ([CD_EMP],[CD_PED_SOL],[CD_PROD])
INCLUDE ([QT_IT_SOL],[QT_IT_AT],[QT_SLD],[CONV_UNIDADE],[QT_IT_UN],[QT_IT_AT_UN],[QT_SLD_UN],[VLR_PROD]);

 --------------------------------------------------------------------------------------------        
 --VERIFICANDO O PRÓXIMO PEDIDO DO PW CONFORME PARAMETROS DE COMPRA        
 --------------------------------------------------------------------------------------------
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - VERIFICANDO O PRÓXIMO PEDIDO DO PW CONFORME PARAMETROS DE COMPRA'
 --------------------------------------------------------------------------------------------
 INSERT INTO #RS_PROD_CP_PARAM
    (CD_CTR_HIST  ,
      CD_ROTEIRO  ,
      CD_ORD_ROTEIRO ,
      CD_PED_CP_PARAM ,
      CD_ORD_CP_PARAM ,
      CD_ORD_MCP  ,
      CD_ORD_DEFAULT ,
      CD_EMP   ,
      CD_PED_SOL  ,
      CD_FILIAL   ,
      CD_PROD   ,
      CD_FORN   ,
      CD_INT   ,
      CD_CTR_ATIVA  ,
      CONDICAO   ,
	  FLAG_PARAM_MCP,
      ST_PED_VAZIO,
	  ST_PED_VAZIO_MOTIVO)
  SELECT
   Row_number() OVER (ORDER BY CP_PARAM_CAB.CD_ROTEIRO) AS CD_CTR,
   CP_PARAM_CAB.CD_ROTEIRO,
   CP_PARAM_CAB.CD_ORD_ROTEIRO,
   CP_PARAM_CAB.CD_PED_CP_PARAM,
   CP_PARAM_CAB.CD_ORD_CP_PARAM,
   CP_PARAM_CAB.CD_ORD_MCP AS CD_ORD_MCP,
   0 AS CD_ORD_DEFAULT,
   RS_PROD_PEND.CD_EMP,
   RS_PROD_PEND.CD_PED_SOL,
   RS_PROD_PEND.CD_FILIAL,
   RS_PROD_PEND.CD_PROD,
   CP_PARAM_CAB.CD_FORN,
   CP_PARAM_CAB.CD_INT,
   RS_PROD_PEND.CD_CTR_ATIVA,
   Isnull(CP_PARAM_CAB.CONDICAO,'') AS CONDICAO,
   CP_PARAM_CAB.FLAG_PARAM_MCP,
   0 AS ST_PED_VAZIO,
   '' AS ST_PED_VAZIO_MOTIVO
    
  FROM 
  /*#RS_PROD_PEND RS_PROD_PEND
   INNER JOIN #RS_PROD_CP_PARAM_CAB CP_PARAM_CAB ON
    CP_PARAM_CAB.CD_EMP    = RS_PROD_PEND.CD_EMP
    AND CP_PARAM_CAB.CD_PED_SOL   = RS_PROD_PEND.CD_PED_SOL*/
	#RS_PROD_PEND RS_PROD_PEND
	INNER JOIN #RS_PROD_CP_PARAM_CAB CP_PARAM_CAB ON
	CP_PARAM_CAB.CD_EMP		  = RS_PROD_PEND.CD_EMP AND 
	CP_PARAM_CAB.CD_PED_SOL   = RS_PROD_PEND.CD_PED_SOL AND
	CP_PARAM_CAB.CD_CTR_ATIVA = RS_PROD_PEND.CD_CTR_ATIVA AND
	CP_PARAM_CAB.CD_ROTEIRO	  = RS_PROD_PEND.CD_ROTEIRO
    
	CREATE NONCLUSTERED INDEX [#IDX_RS_PROD_CP_PARAM_CD_PROD] ON [dbo].[#RS_PROD_CP_PARAM] ([CD_EMP],[CD_PED_SOL],[CD_PROD])
	INCLUDE ([CD_ROTEIRO],[CD_ORD_ROTEIRO],[CD_PED_CP_PARAM],[CD_ORD_CP_PARAM],
				[CD_ORD_MCP],[CD_ORD_DEFAULT],[CD_FORN],[CD_INT],
				[CD_CTR_ATIVA],[CONDICAO],[ST_PED_VAZIO],[ST_PED_VAZIO_MOTIVO]);
			
    CREATE NONCLUSTERED INDEX [#IDX_RS_PROD_CP_PARAM_CD_PROD_II] ON [dbo].[#RS_PROD_CP_PARAM] ([CD_EMP],[CD_PROD],[CD_PED_CP_PARAM]);
			
 IF EXISTS (SELECT TOP 1 CD_EMP FROM #RS_PROD_CP_PARAM)
  BEGIN
   --------------------------------------------------------------------------------------------        
   --PERMANECENDO APENAS A PROXIMA ORDEM VALIDA DE COMPRA    
   --------------------------------------------------------------------------------------------      
   PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - PERMANECENDO APENAS A PROXIMA ORDEM VALIDA DE COMPRA'
   --------------------------------------------------------------------------------------------
   DELETE RS_CP_PARAM
   FROM #RS_PROD_CP_PARAM RS_CP_PARAM
   WHERE RS_CP_PARAM.FLAG_PARAM_MCP = 0  
		AND NOT EXISTS
        (SELECT RS.*
         FROM
        (SELECT DISTINCT
          RS.CD_PED_SOL, RS.CD_ROTEIRO, RS.CD_ORD_CP_PARAM, RS.CD_ORD_ROTEIRO,
          Row_number() OVER (PARTITION BY RS.CD_PED_SOL, RS.CD_ROTEIRO
                 ORDER BY RS.CD_PED_SOL, RS.CD_ROTEIRO, RS.CD_ORD_ROTEIRO, RS.CD_ORD_CP_PARAM) AS CD_CTR,
          RS.CD_EMP
         FROM #RS_PROD_CP_PARAM RS
         GROUP BY
          RS.CD_PED_SOL, RS.CD_ROTEIRO, RS.CD_ORD_ROTEIRO,  RS.CD_ORD_CP_PARAM, RS.CD_EMP) RS
         WHERE
        RS.CD_CTR = 1
           AND RS_CP_PARAM.CD_ROTEIRO  = RS.CD_ROTEIRO
        AND RS_CP_PARAM.CD_ORD_ROTEIRO  = RS.CD_ORD_ROTEIRO
        AND RS_CP_PARAM.CD_ORD_CP_PARAM = RS.CD_ORD_CP_PARAM
        AND RS_CP_PARAM.CD_EMP   = RS.CD_EMP
        AND RS_CP_PARAM.CD_PED_SOL  = RS.CD_PED_SOL)
                   

   --------------------------------------------------------------------------------------------        
   --PERMANECENDO APENAS A PROXIMA ORDEM VALIDA DA MELHOR CONDICAO DE COMPRA - SOMENTE PARA PARAMETROS QUE SEJA MCP
   --------------------------------------------------------------------------------------------      
   PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - PERMANECENDO APENAS A PROXIMA ORDEM VALIDA DA MELHOR CONDICAO DE COMPRA - SOMENTE PARA PARAMETROS'
   --------------------------------------------------------------------------------------------
   DELETE RS_CP_PARAM
   FROM #RS_PROD_CP_PARAM RS_CP_PARAM
   WHERE RS_CP_PARAM.FLAG_PARAM_MCP = 1			
			AND RS_CP_PARAM.CD_ORD_MCP <> ISNULL((SELECT MAX(ROT_HIST.CD_ORD_MCP) AS CD_ORD_MCP
												FROM EST_PED_ELTR_ATIVA_CP_HIST_PARAM ROT_HIST
												WHERE  RS_CP_PARAM.CD_CTR_ATIVA = ROT_HIST.CD_CTR
													AND RS_CP_PARAM.CD_ROTEIRO  = ROT_HIST.CD_ROTEIRO
													AND RS_CP_PARAM.CD_ORD_ROTEIRO  = ROT_HIST.CD_ORD_ROTEIRO
													AND RS_CP_PARAM.CD_ORD_CP_PARAM = ROT_HIST.CD_ORD_CP_PARAM
													AND RS_CP_PARAM.CD_EMP   = ROT_HIST.CD_EMP
													AND RS_CP_PARAM.CD_PED_SOL  = ROT_HIST.CD_PED_SOL), 0) + 1
													
   --------------------------------------------------------------------------------------------        
   --IDENTIFICANDO PRODUTOS E A ORDEM DA MCP PARA OS PARAMETROS
   --------------------------------------------------------------------------------------------
   PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - IDENTIFICANDO PRODUTOS E A ORDEM DA MCP PARA OS PARAMETROS'
   --------------------------------------------------------------------------------------------
 
   INSERT INTO #RS_PROD_MCP 
		(CD_EMP,
		 CD_ORD_MCP,
		 CD_PROD,
		 CD_FORN,
		 CD_PED_CP_PARAM)
	SELECT 
		MCP.CD_EMP,
		--ROW_NUMBER() OVER (PARTITION BY   MCP.CD_PROD, PARAM_FORN.CD_PED_CP_PARAM ORDER BY MCP.CD_PROD, MCP.CD_ORDEM) AS CD_ORD_MCP, 			
	     MCP.CD_ORDEM,
		MCP.CD_PROD,
		MCP.CD_FORN,
		PARAM_FORN.CD_PED_CP_PARAM
	FROM 
	   V_EST_PROD_COND_CP_PG_FORN_VIGENTE MCP 
	   INNER JOIN EST_PED_CP_PARAM_PG_FORN_INTEGRACAO PARAM_FORN ON 
	   MCP.CD_EMP = PARAM_FORN.CD_EMP
	   AND MCP.CD_FORN = PARAM_FORN.CD_FORN
		
	   INNER JOIN EST_PED_CP_PARAM  X ON 
	   PARAM_FORN.CD_EMP = X.CD_EMP
	   AND PARAM_FORN.CD_PED_CP_PARAM = X.CD_PED_CP_PARAM  
	WHERE 
		x.cd_emp=1
		and CASE WHEN ISNULL(LIMITE_ENV_MCC,0) =0 THEN CD_ORDEM
			ELSE LIMITE_ENV_MCC END >= CD_ORDEM 
		AND EXISTS (SELECT CD_EMP 
				    FROM #RS_PROD_CP_PARAM RS_PROD_CP_PARAM
				    WHERE RS_PROD_CP_PARAM.CD_EMP 				= MCP.CD_EMP
						 AND RS_PROD_CP_PARAM.CD_PROD 			= MCP.CD_PROD
						 AND RS_PROD_CP_PARAM.CD_PED_CP_PARAM 	= PARAM_FORN.CD_PED_CP_PARAM)
	   
	  update mcp
	  set CD_ORD_MCP = a.new_CD_ORD_MCP
	  from
	   #RS_PROD_MCP mcp
	   JOIN (SELECT 
			 CD_PROD, 
			 CD_FORN,
			 CD_PED_CP_PARAM,
			 CD_ORD_MCP,  
			 ROW_NUMBER() OVER (PARTITION BY   CD_PROD, CD_PED_CP_PARAM ORDER BY CD_PROD, CD_ORD_MCP)  new_CD_ORD_MCP
			 FROM #RS_PROD_MCP) a on 
	   mcp.CD_PROD = a.CD_PROD and 
	   mcp.CD_FORN	= a.CD_FORN and
	   mcp.CD_PED_CP_PARAM = a.CD_PED_CP_PARAM and
	   mcp.CD_ORD_MCP  = a.CD_ORD_MCP ;
					
   --------------------------------------------------------------------------------------------        
   --FILTRANDO OS PRODUTOS DA ORDEM DE PRECO DA MCP
   --------------------------------------------------------------------------------------------
   PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - FILTRANDO OS PRODUTOS DA ORDEM DE PRECO DA MCP'
   --------------------------------------------------------------------------------------------   
   UPDATE RS_CP_PARAM SET 
		ST_PED_VAZIO = 1,
		ST_PED_VAZIO_MOTIVO = 'ELIMINADO PELA MELHOR CONDICAO DE COMPRA - NAO ATENTE A ORDEM DO PRECO'
   FROM #RS_PROD_CP_PARAM RS_CP_PARAM		
   WHERE 
		RS_CP_PARAM.FLAG_PARAM_MCP = 1
		AND NOT EXISTS (SELECT CD_EMP 
						FROM #RS_PROD_MCP #RS_PROD_MCP
						WHERE #RS_PROD_MCP.CD_EMP 				= RS_CP_PARAM.CD_EMP
							  AND #RS_PROD_MCP.CD_PROD 			= RS_CP_PARAM.CD_PROD
							  AND #RS_PROD_MCP.CD_PED_CP_PARAM 	= RS_CP_PARAM.CD_PED_CP_PARAM
							  AND #RS_PROD_MCP.CD_FORN 			= RS_CP_PARAM.CD_FORN
							  AND #RS_PROD_MCP.CD_ORD_MCP		= RS_CP_PARAM.CD_ORD_MCP)

   --------------------------------------------------------------------------------------------        
   --FILTRANDO FILIAIS DEFINIDAS NO PARAMETRO
   --------------------------------------------------------------------------------------------
   PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - FILTRANDO FILIAIS DEFINIDAS NO PARAMETRO'
   --------------------------------------------------------------------------------------------   
   UPDATE RS_CP_PARAM SET 
		ST_PED_VAZIO = 1,
		ST_PED_VAZIO_MOTIVO = 'ELIMINADO PELO PARAMETRO DE COMPRA - NAO ATENDE A FILIAL'
   FROM #RS_PROD_CP_PARAM RS_CP_PARAM
   WHERE NOT EXISTS   (SELECT UFD_CP_PARAM_F.CD_EMP
        FROM Ufd_est_ped_cp_param_prc_filial() UFD_CP_PARAM_F
        WHERE
         RS_CP_PARAM.CD_EMP    = UFD_CP_PARAM_F.CD_EMP
         AND RS_CP_PARAM.CD_PED_CP_PARAM = UFD_CP_PARAM_F.CD_PED_CP_PARAM
         AND RS_CP_PARAM.CD_FILIAL  = (CASE WHEN UFD_CP_PARAM_F.FLAG_TODAS_FILIAIS = 0 THEN
                   UFD_CP_PARAM_F.CD_FILIAL
                    ELSE RS_CP_PARAM.CD_FILIAL END))
       
   --------------------------------------------------------------------------------------------        
   --FILTRANDO PRODUTOS DEFINIDOS NO PARAMETRO
   --------------------------------------------------------------------------------------------
   PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - FILTRANDO PRODUTOS DEFINIDOS NO PARAMETRO'
   --------------------------------------------------------------------------------------------   
   UPDATE RS_CP_PARAM SET
		ST_PED_VAZIO = 1,
		ST_PED_VAZIO_MOTIVO = 'ELIMINADO PELO PARAMETRO DE COMPRA - NAO ATENDE O PRODUTO'
   FROM #RS_PROD_CP_PARAM RS_CP_PARAM
		INNER JOIN EST_PED_CP_PARAM CP_PARAM ON
			RS_CP_PARAM.CD_EMP = CP_PARAM.CD_EMP
			AND RS_CP_PARAM.CD_PED_CP_PARAM = CP_PARAM.CD_PED_CP_PARAM
		INNER JOIN EST_PROD P ON
			RS_CP_PARAM.CD_EMP = P.CD_EMP
			AND RS_CP_PARAM.CD_PROD = P.CD_PROD
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
			ARV.CD_EMP = P.CD_EMP
			AND ARV.CD_PROD = P.CD_PROD
		OUTER APPLY UFD_EST_PED_CP_PARAM_PROD(P.CD_EMP, RS_CP_PARAM.CD_PED_CP_PARAM, ARV.CD_ARV_MERC_LINHA, P.CD_FABRIC, P.CD_PROD) CP_PARAM_PROD
   WHERE
		RS_CP_PARAM.ST_PED_VAZIO = 0		
		AND RS_CP_PARAM.CD_EMP    = @CD_EMP
		AND
		(		-- Cadastro Produtos
				-- 0 - SEM VAN COMRPAS
				-- 1 - PHARMALINK
				-- 2 - ENTIRE
				-- 3 - PHARMALINK ENTIRE
				-- 4 - OL MIX
				-- 5 - FIDELIZE
				-- 6 - WEBOL

				--Tela parametros
				-- 0 SEM VINCULO COM O PHARMALINK
				-- 1 COM VINCULO COM O PHARMALINK
				-- 2 IGNORAR VINCULO COM O PHARMALINK
				-- 3 COM VINCULO COM A ENTIRE
				-- 4 COM VINCULO COM A ENTIRE E PHARMALINK
				-- 5 COM VINCULO OL MIX
				-- 6 COM VINCULO FIDELIZE
				-- 7 COM VINCULO WEBOL
				
				P.FLAG_COMPRA_PHARMALINK NOT IN (SELECT ID FROM Ufd_prm_in_string((CASE CP_PARAM.TP_FILTRO_PHLINK
																					--WHEN '0' THEN '1,2,3,4,5'
																					WHEN '1' THEN '1,3'
																					WHEN '2' THEN '1,2,3,4,5,6,7,8,9,0'
																					WHEN '3' THEN '2,3'
																					WHEN '4' THEN '4'
																					WHEN '5' THEN '4'
																					WHEN '6' THEN '5'
																					WHEN '7' THEN '6'
																					ELSE Cast(CP_PARAM.TP_FILTRO_PHLINK AS VARCHAR)
																				 END)))
			OR CP_PARAM_PROD.CD_EMP IS NULL
		)
        
  END
 --##########################################################################################    
 --FIM TRATAMENTO DE CONDICOES COMERCIAIS DO PW    
 --##########################################################################################         

 
  --------------------------------------------------------------------------------------------        
  --ALIMENTANDO A TABELA DE RETORNO DOS PEDIDOS ELETRONICOS.        
  --------------------------------------------------------------------------------------------
  PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - ALIMENTANDO A TABELA DE RETORNO DOS PEDIDOS ELETRONICOS.'
   --------------------------------------------------------------------------------------------  
  INSERT INTO #BUSCA_QT_SOL_PED_CP
    (CD_EMP    ,
     CD_PED_SOL   ,
     CD_FILIAL   ,
     CD_FORN   ,
     CD_INT    ,
     CD_FIL_FORN  ,
     CD_PROD   ,
     CD_PROD_FORN  ,
     DS_PROD   ,
     DS_UN    ,
     QT_IT_SOL   ,
     QT_IT_AT   ,
     QT_SLD    ,
	 CONV_UNIDADE,
	 QT_IT_UN,
	 QT_IT_AT_UN,
	 QT_SLD_UN,
     VLR_PROD   ,
     VLR_TOT_PROD  ,
     CD_FABRIC   ,
     NM_FABRIC   ,
     PERC_DESC   ,
     CTR_PMC   ,
     CD_BARRA   ,
     FLAG_GERAR_CROSS   ,
     TP_REQ    ,
     CD_ROTEIRO   ,
     CD_ORD_ROTEIRO  ,
     CD_PED_CP_PARAM ,
     CD_ORD_CP_PARAM ,
     CD_ORD_MCP   ,
     CD_ORD_DEFAULT  ,
     CD_CTR_ATIVA  ,
     CONDICAO,
     ST_PED_VAZIO,
	 ST_PED_VAZIO_MOTIVO,
	 QT_EMB)
      
   SELECT
    EST_PED_ELTR.CD_EMP,
    EST_PED_ELTR.CD_PED_SOL,
    EST_PED_ELTR.CD_FIL_ENTR,
    RS_CP_PARAM.CD_FORN,
    RS_CP_PARAM.CD_INT,
    '' AS CD_FIL_FORN,
    RS_PROD_PEND.CD_PROD,
    '' AS CD_PROD_FORN,
    EST_PROD.DS_PROD,
    EST_PROD_UN_MED.DS_UN,
    RS_PROD_PEND.QT_IT_SOL,
    RS_PROD_PEND.QT_IT_AT,
    RS_PROD_PEND.QT_SLD,
	RS_PROD_PEND.CONV_UNIDADE,
	RS_PROD_PEND.QT_IT_UN,
	RS_PROD_PEND.QT_IT_AT_UN,
	RS_PROD_PEND.QT_SLD_UN,
    RS_PROD_PEND.VLR_PROD,
    (RS_PROD_PEND.QT_SLD * RS_PROD_PEND.VLR_PROD) AS VLR_TOT_PROD,
    EST_PROD.CD_FABRIC,
    EST_PROD_FABRIC.NM_FABRIC,
    0 AS PERC_DESC,
    EST_PROD.CTR_PMC,
    (SELECT TOP 1 B.CD_BARRA FROM EST_PROD_CD_BARRA B WHERE B.CD_EMP = EST_PROD.CD_EMP AND B.CD_PROD = EST_PROD.CD_PROD AND Isnull(B.NAO_USAR_PED_ELETR,0) = 0) AS CD_BARRA,
    Isnull(EST_PED_ELTR.FLAG_GERAR_CROSS,0) AS FLAG_GERAR_CROSS,
    EST_PED_ELTR.TP_REQ,
    RS_CP_PARAM.CD_ROTEIRO,
    RS_CP_PARAM.CD_ORD_ROTEIRO,
    RS_CP_PARAM.CD_PED_CP_PARAM,
    RS_CP_PARAM.CD_ORD_CP_PARAM,
    RS_CP_PARAM.CD_ORD_MCP,
    RS_CP_PARAM.CD_ORD_DEFAULT,
    RS_CP_PARAM.CD_CTR_ATIVA,
    RS_CP_PARAM.CONDICAO,
    RS_CP_PARAM.ST_PED_VAZIO,
	RS_CP_PARAM.ST_PED_VAZIO_MOTIVO,
	CONVERT(MONEY,REPLACE(EST_PROD.APRES_EMB_CP,',','.')) *  CONVERT(MONEY,REPLACE(EST_PROD.APRES_QT_CP,',','.')) AS QT_EMB
	
   FROM
    EST_PED_ELTR
    INNER JOIN #RS_PROD_PEND RS_PROD_PEND ON
     EST_PED_ELTR.CD_EMP   = RS_PROD_PEND.CD_EMP AND
     EST_PED_ELTR.CD_PED_SOL  = RS_PROD_PEND.CD_PED_SOL
    INNER JOIN #RS_PROD_CP_PARAM RS_CP_PARAM ON
     RS_PROD_PEND.CD_EMP   = RS_CP_PARAM.CD_EMP AND
     RS_PROD_PEND.CD_PED_SOL  = RS_CP_PARAM.CD_PED_SOL AND
     RS_PROD_PEND.CD_PROD  = RS_CP_PARAM.CD_PROD
    INNER JOIN EST_PROD ON
     RS_CP_PARAM.CD_EMP = EST_PROD.CD_EMP AND
     RS_CP_PARAM.CD_PROD = EST_PROD.CD_PROD
    INNER JOIN EST_PROD_UN_MED ON
     EST_PROD.CD_EMP  = EST_PROD_UN_MED.CD_EMP AND
     EST_PROD.CD_UN_CP = EST_PROD_UN_MED.CD_CTR_UN
    INNER JOIN EST_PROD_FABRIC ON
     EST_PROD.CD_FABRIC = EST_PROD_FABRIC.CD_FABRIC
WHERE       
	EST_PED_ELTR.CD_EMP=@CD_EMP;
          
 --------------------------------------------------------------------------------------------        
 --ATUALIZANDO O CODIGO DA FILIAL NO FORNECEDOR       
 --------------------------------------------------------------------------------------------
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - ATUALIZANDO O CODIGO DA FILIAL NO FORNECEDOR'
   -------------------------------------------------------------------------------------------- 
UPDATE RS SET
CD_FIL_FORN = Isnull(PG_FORN_CD_FIL_FORN.CD_FIL_FORN,'')
FROM 
	#BUSCA_QT_SOL_PED_CP RS
	INNER JOIN PG_FORN_CD_FIL_FORN ON
	RS.CD_EMP  = PG_FORN_CD_FIL_FORN.CD_EMP AND
	RS.CD_FORN  = PG_FORN_CD_FIL_FORN.CD_FORN AND
	RS.CD_FILIAL = PG_FORN_CD_FIL_FORN.CD_FILIAL
             
      
 ------------------------------------------------------------------------------------------------------------------------------------------        
 --DEFININDO O CODIGO DO PRODUTO NO FORNECEDOR, CONFORME TABELA DE DICIONARIO OU EAN    
 ------------------------------------------------------------------------------------------------------------------------------------------
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - DEFININDO O CODIGO DO PRODUTO NO FORNECEDOR, CONFORME TABELA DE DICIONARIO OU EAN'
 -------------------------------------------------------------------------------------------- 
 UPDATE RS 
 SET
	CD_PROD_FORN = (CASE WHEN PG_FORN.FLAG_CD_PROD_FORN_EAN = 1 THEN
						Isnull(RS.CD_BARRA,'')	COLLATE SQL_Latin1_General_CP1_CI_AS
					ELSE
						F.CD_PROD_FORN			COLLATE SQL_Latin1_General_CP1_CI_AS
					END),
	QT_EMB = (CASE WHEN (APRES_EMB_CP * APRES_QT_CP) > 0 THEN (APRES_EMB_CP * APRES_QT_CP) ELSE RS.QT_EMB END), 
	ST_PED_VAZIO = CASE WHEN F.COMPRA_INATIVA = 1 THEN 1 ELSE ST_PED_VAZIO END,
	ST_PED_VAZIO_MOTIVO = CASE WHEN F.COMPRA_INATIVA = 1 THEN  'PRODUTO INATIVO FORNECEDOR' ELSE ST_PED_VAZIO_MOTIVO END
 FROM 
	#BUSCA_QT_SOL_PED_CP RS
	INNER JOIN EST_PROD_FORN F ON
	RS.CD_EMP	= F.CD_EMP AND
	RS.CD_PROD  = F.CD_PROD AND
	RS.CD_FORN  = F.CD_FORN   
	INNER JOIN PG_FORN ON
	F.CD_EMP = PG_FORN.CD_EMP AND
	F.CD_FORN = PG_FORN.CD_FORN
 WHERE
	RS.ST_PED_VAZIO = 0
    AND F.CD_EMP=1;
		 

 ------------------------------------------------------------------------------------------------------------------------------------------        
 --DEFININDO O CODIGO DO PRODUTO NO FORNECEDOR, CONFORME TABELA DE DICIONARIO OU EAN    
 ------------------------------------------------------------------------------------------------------------------------------------------
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - DEFININDO O CODIGO DO PRODUTO NO FORNECEDOR, CONFORME TABELA DE DICIONARIO OU EAN'
 -------------------------------------------------------------------------------------------- 
UPDATE RS SET
QT_SLD = Round((QT_SLD_UN / QT_EMB),0)
FROM #BUSCA_QT_SOL_PED_CP RS
WHERE
	RS.ST_PED_VAZIO = 0
	AND CD_PROD_FORN <> '';
	
	
--------------------------------------------------------------------------------------------        
 --FORCA ELIMINACAO DE PRODUTO EM MAIS DE UMA MCC   
--------------------------------------------------------------------------------------------
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - ELIMINADO PELO PROCESSO DE MCC - ORDEM ERRADA'
-------------------------------------------------------------------------------------------- 
 
 UPDATE A
 SET
	ST_PED_VAZIO = 1,
	ST_PED_VAZIO_MOTIVO = 'ELIMINADO PELO PROCESSO DE MCC - ORDEM ERRADA'
	
 FROM #BUSCA_QT_SOL_PED_CP A
 
 WHERE 
 A.ST_PED_VAZIO = 0 
 AND A.CD_ORD_MCP <> 0 
 AND A.CD_ORD_MCP <> ISNULL((SELECT MAX(ROT_HIST.CD_ORD_MCP) AS CD_ORD_MCP
												FROM EST_PED_ELTR_ATIVA_CP_HIST_PARAM ROT_HIST
												WHERE  A.CD_CTR_ATIVA = ROT_HIST.CD_CTR
													AND A.CD_ROTEIRO  = ROT_HIST.CD_ROTEIRO
													AND A.CD_EMP   = ROT_HIST.CD_EMP
													AND A.CD_PED_SOL  = ROT_HIST.CD_PED_SOL), 0) + 1

 --------------------------------------------------------------------------------------------        
 --RETORNANDO PRODUTOS PARA ENVIO DE PEDIDO    
 --------------------------------------------------------------------------------------------
 PRINT CONVERT(VARCHAR(30), GETDATE(),108) + ' - RETORNANDO PRODUTOS PARA ENVIO DE PEDIDO'
 -------------------------------------------------------------------------------------------- 
	SELECT DISTINCT
		PED.*, PRC_FILIAL.CGC, PRC_FILIAL.NM_FANT
	FROM 
		#BUSCA_QT_SOL_PED_CP PED
		INNER JOIN PRC_FILIAL ON
		PED.CD_EMP   = PRC_FILIAL.CD_EMP
		AND PED.CD_FILIAL = PRC_FILIAL.CD_FILIAL
	ORDER BY 
		PED.CD_FILIAL, PED.CD_PED_SOL, 
		CD_ROTEIRO, CD_ORD_MCP, CD_ORD_ROTEIRO, CD_ORD_CP_PARAM, 
		CD_ORD_DEFAULT, PED.DS_PROD
         
         
 RETURN
     
END

